PROCEDURE WriteBreakoutXML;	
{DEBUG}

CONST
	{INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_CONST.px}
	kDefaultBOXML2 = 'AP BI w Len INVENTORY.xml';

	kMultiRecName					= 'AP Multicable';
	kDataRecName					= 'AP Data Cable';
	kJumperRecName					= 'AP Jumper Cable';
	kFeederRecName					= 'AP Feeder Cable';
	kBOLabelName					= 'AP Break Out';

	kMaxinventories				= 25;
	kDefaultFeederXML				= 'AP Feeder Imperial INVENTORY.xml';
	kDefaultMultiXML				= 'AP Multicable INVENTORY.xml';
	kDefaultJumperXML				= 'AP Jumper INVENTORY.xml';
	kDefaultDataXML				= 'AP Data INVENTORY.xml';

	kDefaultMetricFeederXML		= 'AP Feeder Metric INVENTORY.XML';
	kDefaultMetricMultiXML		= 'AP Multicable Metric INVENTORY.xml';
	kDefaultMetricJumperXML		= 'AP Jumper Metric INVENTORY.xml';
	kDefaultMetricDataXML		= 'AP Data Metric INVENTORY.xml';
	kDefaultBOXML					= 'AP Breakout INVENTORY.xml';
	kDefaultBIXML					= 'AP Breakin INVENTORY.xml';

	kXMLFeedMainTag 				= 'FeederInventory';
	kXMLMultiMainTag 				= 'MulticableInventory';
	kXMLJumpMainTag 				= 'JumperInventory';
	kXMLDataMainTag 				= 'DataInventory';
	kXMLBreakoutMainTag			= 'BreakoutInventory';
	kXMLBreakinMainTag			= 'BreakinInventory';

	kMasterInventoryFolder		= 'AP Cable Inventories';
	kFeederFileFolder				= 'AP Feeder Inventory Files';
	kMultFileFolder				= 'AP Multicable Inventory Files';
	kJumperFileFolder				= 'AP Jumper Inventory Files';
	kDataFileFolder				= 'AP Data Inventory Files';
	kBOFileFolder					= 'AP Breakout Inventory Files';
	kBIFileFolder					= 'AP Breakin Inventory Files';

VAR
	{INCLUDE VW_Spotlight\Includes\CableTools\GLOBAL_VARS.px}
	AwgCnt			:INTEGER;
	AwgField			:STRING;
	BOCnt				:INTEGER;
	BOField			:STRING;
	BOTypes			:ARRAY[1..50] OF STRING;
	BooFlag			:BOOLEAN;
	BreakOutFile	:Dynarray of CHAR;
	CableField		:STRING;
	StagLenField	:STRING;
	EntryStr			:STRING;
	FirstElement	:STRING;
	hXML				:LONGINT;
	InventoryF		:STRING;
	InventoryFile	:STRING;
	LenField			:STRING;
	maintenance		:INTEGER;
	major				:INTEGER;
	minor				:INTEGER;
	Platform			:INTEGER;
	ParamName		:STRING;
	PlugInPath		:STRING;
	PlugPath			:STRING;
	RecName			:STRING;
	Result			:INTEGER;
	TypeCnt			:INTEGER;
	WtField			:STRING;
	xmlFileNpath	:Dynarray of CHAR;
	xmlFileNpathS	:STRING;
	xmlMainTag		:STRING;
		
{==============================================================}

	PROCEDURE WriteBreakOuts;
	
	VAR
		awgIndex			:INTEGER;
		awgVal			:STRING;
		cableVal			:STRING;
		connIndex		:INTEGER;
		connVal			:STRING;
		elementHolder	:STRING;
		lenVal			:STRING;
		stagLenVal		:STRING;
		typeIndex		:INTEGER;
		wtVal				:STRING;

	BEGIN	
		Result := 0; {Make results valid be default}

		IF ReadXMLFile(hXML, -1, BreakOutFile) <> 0 THEN {If the file does not exist create one}
			Result := CreateNewXMLDocument(hXML, xmlMainTag);
			
		IF Result = 0 THEN
			BEGIN
				(* xmlExpFlds := Concat('/',xmlMainTag,'/',FirstElement); *)
				lenVal := '6''';
				stagLenVal := '1''/2''/3''/4''/5''/6''';
				FOR connIndex := 1 TO BOCnt DO
					BEGIN
						connVal := BOTypes[connIndex]; 
						elementHolder := CONCAT('/',xmlMainTag, '/', BOField, Num2Str(0,connIndex), '/BIType');
						
						Result := SetElementValue(hXML, elementHolder, connVal); 
						
						elementHolder := CONCAT('/',xmlMainTag, '/', BOField, Num2Str(0,connIndex), '/','Length');
						Result := SetElementValue(hXML, elementHolder, lenVal);
						
						elementHolder := CONCAT('/',xmlMainTag, '/', BOField, Num2Str(0,connIndex), '/','StagLength');
						Result := SetElementValue(hXML, elementHolder, stagLenVal);
						
					END; {FOR TypeIndex := 1 TO TypeCnt}
				result := WriteXMLFile(hXML, -1, BreakOutFile); {Actually write the file do disk}
(*AlrtDialog(concat('BreakOutFile = ', BreakOutFile, chr(13), 'result = ', result));*)
			END; {IF Result = 0 }
	END; {PROCEDURE WriteBreakOuts}
	
{==============================================================}

	PROCEDURE FillBOArray;
		
	BEGIN
		BOTypes[1] :=		'Soca > 6xSPG(2P&G)';
		BOTypes[2] :=		'Soca > 6xPBG(Edison)';
		BOTypes[3] :=		'Soca 12/19 > 6xPBG(Edison)';
		BOTypes[4] :=		'Soca > 6xL5-15';
		BOTypes[5] :=		'Soca > 6xL5-20';
		BOTypes[6] :=		'Soca > 6xL5-30';
		BOTypes[7] :=		'Soca > 6xL6-15';
		BOTypes[8] :=		'Soca > 6xL6-20';
		BOTypes[9] :=		'Soca > 6xL6-30';
		BOTypes[10] :=		'Soca > 6xCEE16/3';
		BOTypes[11] :=		'Soca > 4xCEE16/4';
		BOTypes[12] :=		'Soca > 3xCEE32/3';
		BOTypes[13] :=		'Soca > 6xSchuko';
		BOTypes[14] :=		'Soca > 6xM1';
		BOTypes[15] :=		'Soca > 3xVEAM575/1200';
		BOTypes[16] :=		'Soca > 2xVEAM2,5/4';
		BOTypes[17] :=		'Soca > 3xM1';
		BOTypes[18] :=		'Soca > 6xBS 546';
		BOTypes[19] :=		'Soca > 6xBS 1363';
		BOTypes[20] :=		'Soca > 6xIEC'; 
		BOTypes[21] :=		'Soca > 4xMotor 400v';
		BOTypes[22] :=		'Soca > 4xMotor 110v';
		BOTypes[23] :=		'Soca > 6xAmphenol7pol';
		BOTypes[24] :=		'Soca > 6xSmart Repeater VL 5';
		BOTypes[25] :=		'Veam/Soco Twofer 19 pin';
		BOTypes[26] :=		'HAN16 > 6xCEE16/3';
		BOTypes[27] :=		'HAN16 > 6xSchuko';
		BOTypes[28] :=		'HAN16 > 4xCEE16/4';
		BOTypes[29] :=		'HAN16 > 3xVEAM575/1200';
		BOTypes[30] :=		'HAN16 > 3xCEE16/5';
		BOTypes[31] :=		'HAN16 > 3xCEE32/3';
		BOTypes[32] :=		'HAN16 > 3xM1';
		BOTypes[33] :=		'HAN16 > 2xCEE16/5';
		BOTypes[34] :=		'M3 > 6xAmphenol7pol';
		BOTypes[35] :=		'M3 > 3xAmphenol7pol';
		BOTypes[36] :=		'QM Snake > 6xDMX 5pin m';
		BOTypes[37] :=		'C37 > 12xXLR m';
		BOTypes[38] :=		'C37 > 12xXLR f';
		BOTypes[39] :=		'C37 > 12xXLR m/f box';
		BOTypes[40] :=		'* > 12xXLR 3pin f';
		BOTypes[41] :=		'* > 2xDMX 5pin m';
		BOTypes[42] :=		'* > 4xDMX 5pin m';
		BOCnt := 42;

	END; {PROCEDURE FillBOArray}
	
{==============================================================}

BEGIN
Alrtdialog('Reading correct CREATE file');
	BreakOutFile := kDefaultBOXML2;
	
	GetVersion(Major,Minor,Maintenance,Platform);
	
	{SET THE PATH TO THE XML FILE TO BE WRITTEN);}	
	BooFlag	 := CreateFolder(Concat(GetFolderPath(-2), kMasterInventoryFolder));
	BooFlag	 := CreateFolder(Concat(GetFolderPath(-2), kMasterInventoryFolder, '/', kBIFileFolder));
	BreakOutFile := CONCAT(GetFolderPath(-2), kMasterInventoryFolder, '/', kBIFileFolder, '/', BreakOutFile);
	
	xmlMainTag := kXMLBreakinMainTag;

	{SET THE FIELDS FOR THE XML FILE}
	BOField := 'Breakin';
	LenField := 'Lengths';
	StagLenField := 'Staggered Lengths';
	
	{COLLECT NUMBER OF CHOICES}
	FillBOArray;

	hXML := InitXML; {init the xml handling, create an xml file handle}

   	IF hXML <> 0 THEN 
		BEGIN
			WriteBreakOuts;
			result := ReleaseXML(hXML); {Release xml memory}
		END;
		AlrtDialog('Create Break In XML Complete');
END;
RUN(WriteBreakoutXML);